/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.HashSet;
import java.util.Vector;

public class VWWorkClassProxy {
    public static final int TYPE_WORKCLASS_LOCAL = 0;
    public static final int TYPE_WORKCLASS_SERVER = 1;
    private String m_workClassName = null;
    private int m_nWorkClassType = 1;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWWorkflowSignature m_workflowSignature = null;

    public VWWorkClassProxy(String name, int nType, VWAuthPropertyData authPropertyData) {
        this.m_workClassName = name;
        this.m_nWorkClassType = nType;
        this.m_authPropertyData = authPropertyData;
    }

    public static VWWorkClassProxy[] getAvailableWorkClasses(VWAuthPropertyData authPropertyData) {
        Object[] workClasses = null;
        try {
            if (authPropertyData != null) {
                String[] workClassNames;
                int nIndex;
                VWWorkflowDefinition[] wflDefs;
                Vector<VWWorkClassProxy> listOfNames = new Vector<VWWorkClassProxy>();
                HashSet<String> localWorkClassMap = new HashSet<String>();
                if (authPropertyData.getWorkflowCollectionDefinition() != null && (wflDefs = VWClassFactory.VWWorkflowCollectionDefinition_getWorkflows(authPropertyData.getWorkflowCollectionDefinition(), true, 234L)) != null) {
                    for (nIndex = 0; nIndex < wflDefs.length; ++nIndex) {
                        if (!wflDefs[nIndex].getTransferFlag()) continue;
                        listOfNames.addElement(new VWWorkClassProxy(wflDefs[nIndex].getName(), 0, authPropertyData));
                        localWorkClassMap.add(wflDefs[nIndex].getName());
                    }
                }
                if (authPropertyData.getVWSession() != null && (workClassNames = authPropertyData.getVWSession().fetchWorkClassNames(false)) != null) {
                    for (nIndex = 0; nIndex < workClassNames.length; ++nIndex) {
                        if (localWorkClassMap.contains(workClassNames[nIndex])) continue;
                        listOfNames.addElement(new VWWorkClassProxy(workClassNames[nIndex], 1, authPropertyData));
                    }
                }
                if (listOfNames.size() > 0) {
                    workClasses = new VWWorkClassProxy[listOfNames.size()];
                    listOfNames.copyInto(workClasses);
                    VWQubbleSort.sort(workClasses);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return workClasses;
    }

    public String getName() {
        return this.m_workClassName;
    }

    public int getType() {
        return this.m_nWorkClassType;
    }

    public VWWorkflowSignature getWorkflowSignature() {
        if (this.m_workflowSignature != null) {
            return this.m_workflowSignature;
        }
        if (this.m_authPropertyData != null) {
            switch (this.getType()) {
                case 0: {
                    if (this.m_authPropertyData.getVWSession() == null || this.m_workClassName == null) break;
                    try {
                        VWWorkflowDefinition flatWflDef;
                        VWWorkflowDefinition wflDef = VWClassFactory.VWWorkflowCollectionDefinition_getWorkflow(this.m_authPropertyData.getWorkflowCollectionDefinition(), this.m_workClassName, true, 234L);
                        if (wflDef == null || (flatWflDef = wflDef.getFlattenedCopy(this.m_authPropertyData.getVWSession())) == null) break;
                        flatWflDef.setName(wflDef.getName());
                        this.m_workflowSignature = VWClassFactory.VWWorkflowDefinition_getWorkflowSignature(this.m_authPropertyData.getVWSession(), flatWflDef, 234L);
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                    }
                    break;
                }
                case 1: {
                    if (this.m_authPropertyData.getVWSession() == null || this.m_workClassName == null) break;
                    try {
                        this.m_workflowSignature = this.m_authPropertyData.getVWSession().fetchWorkflowSignature(this.m_workClassName);
                        break;
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                    }
                }
            }
        }
        return this.m_workflowSignature;
    }
}

